
@echo off
REM
REM  A simple RINEX batch file you can modify to suit your own needs
REM  SCSC Simple NTRIP (R) Tools, Rev of Feb 18, 2026
REM
REM 

REM Where the program is to be found, hard code for your own machine
set "RTKLIB_BIN_PATH=C:\Users\First\OneDrive\Desktop\demo5L\"
REM Where data is to be found and saved to, use this method if not passed in by SNIP
REM set "INPUT_DIR=C:\Users\First\OneDrive\Documents\RINEXbatch\input"
REM set "OUTPUT_DIR=C:\Users\First\OneDrive\Documents\RINEXbatch\output"
REM Use below when SNIP sends in paths as command vars
set fileCnt=0
set INPUT_DIR=%1
set OUTPUT_DIR=%2

echo Running script to Convert Files from RTCM3 to RINEX... (Start time: %date% at %time%)
echo Inputs path is %INPUT_DIR%
echo Output path is %OUTPUT_DIR%


REM Create output directory if it doesn't exist
if not exist "%OUTPUT_DIR%" mkdir "%OUTPUT_DIR%"

REM Loop through all raw data files in the input directory
for %%f in ("%INPUT_DIR%\*.dat") do (
    set deleteFile = "%%f"
    echo Converting "%%f" to RINEX...
    REM "%RTKLIB_BIN_PATH%\convbin.exe" "%%f" -r rtcm3 -ti 10 -ho SNIP / YourAgencyName -o "%OUTPUT_DIR%\%%~nf.obs" 
    "%RTKLIB_BIN_PATH%\convbin.exe" "%%f" -r rtcm3 -ti 10 -o "%OUTPUT_DIR%\%%~nf.obs" 
    echo RINEX Conversion complete for: "%%f"
	// REM May want to test here to ensure convert worked before delete call
    del "%%f" 
    echo Created file: "%%~nf.obs"
	
    REM 'tar' requires Window 10 or better, use a 3rd party tool if needed
    if exist "%OUTPUT_DIR%\%%~nf.obs" do (
		REM use local paths to avoid creating folders in the ZIP file
		cd %OUTPUT_DIR%
		set /a fileCnt+=1
		tar.exe -a -c -f "%%~nf.zip" "%%~nf.obs"
		del "%OUTPUT_DIR%\%%~nf.obs"
		echo Zip of RINEX output file created: "%OUTPUT_DIR%\%%~nf.obs"
		echo Created Zip file: "%%~nf.zip"   -Note: the original *.obs file was removed
    )
	
)

REM We presume the output folder is also an FTP site for others
REM Now remove any older files in the putput folder, OBS or ZIP


echo Output files placed at "%OUTPUT_DIR%" 
echo ...All Raw.dat (RTCM) to RINEX.obs files have now been processed (%fileCnt% files) 
echo Ending time: %date% at %time%


